@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The redirect type the rule will use when redirecting traffic.
 */
public enum class RedirectType(
    public val javaValue: com.pulumi.azurenative.cdn.enums.RedirectType,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.RedirectType> {
    Moved(com.pulumi.azurenative.cdn.enums.RedirectType.Moved),
    Found(com.pulumi.azurenative.cdn.enums.RedirectType.Found),
    TemporaryRedirect(com.pulumi.azurenative.cdn.enums.RedirectType.TemporaryRedirect),
    PermanentRedirect(com.pulumi.azurenative.cdn.enums.RedirectType.PermanentRedirect),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.RedirectType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.RedirectType): RedirectType =
            RedirectType.values().first { it.javaValue == javaType }
    }
}
