@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore specific query strings, cache every request with a unique URL, or cache specific query strings.
 */
public enum class RuleQueryStringCachingBehavior(
    public val javaValue: com.pulumi.azurenative.cdn.enums.RuleQueryStringCachingBehavior,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.RuleQueryStringCachingBehavior> {
    IgnoreQueryString(com.pulumi.azurenative.cdn.enums.RuleQueryStringCachingBehavior.IgnoreQueryString),
    UseQueryString(com.pulumi.azurenative.cdn.enums.RuleQueryStringCachingBehavior.UseQueryString),
    IgnoreSpecifiedQueryStrings(com.pulumi.azurenative.cdn.enums.RuleQueryStringCachingBehavior.IgnoreSpecifiedQueryStrings),
    IncludeSpecifiedQueryStrings(com.pulumi.azurenative.cdn.enums.RuleQueryStringCachingBehavior.IncludeSpecifiedQueryStrings),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.RuleQueryStringCachingBehavior = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.RuleQueryStringCachingBehavior): RuleQueryStringCachingBehavior =
            RuleQueryStringCachingBehavior.values().first { it.javaValue == javaType }
    }
}
