@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Status of the shared private link resource. Can be Pending, Approved, Rejected, Disconnected, or Timeout.
 */
public enum class SharedPrivateLinkResourceStatus(
    public val javaValue: com.pulumi.azurenative.cdn.enums.SharedPrivateLinkResourceStatus,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.SharedPrivateLinkResourceStatus> {
    Pending(com.pulumi.azurenative.cdn.enums.SharedPrivateLinkResourceStatus.Pending),
    Approved(com.pulumi.azurenative.cdn.enums.SharedPrivateLinkResourceStatus.Approved),
    Rejected(com.pulumi.azurenative.cdn.enums.SharedPrivateLinkResourceStatus.Rejected),
    Disconnected(com.pulumi.azurenative.cdn.enums.SharedPrivateLinkResourceStatus.Disconnected),
    Timeout(com.pulumi.azurenative.cdn.enums.SharedPrivateLinkResourceStatus.Timeout),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.SharedPrivateLinkResourceStatus =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.SharedPrivateLinkResourceStatus): SharedPrivateLinkResourceStatus =
            SharedPrivateLinkResourceStatus.values().first { it.javaValue == javaType }
    }
}
