@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.AFDDomainHttpsParametersArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.AfdCertificateType
import com.pulumi.azurenative.cdn.kotlin.enums.AfdMinimumTlsVersion
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The JSON object that contains the properties to secure a domain.
 * @property certificateType Defines the source of the SSL certificate.
 * @property minimumTlsVersion TLS protocol version that will be used for Https
 * @property secret Resource reference to the secret. ie. subs/rg/profile/secret
 */
public data class AFDDomainHttpsParametersArgs(
    public val certificateType: Output<Either<String, AfdCertificateType>>,
    public val minimumTlsVersion: Output<AfdMinimumTlsVersion>? = null,
    public val secret: Output<ResourceReferenceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.AFDDomainHttpsParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.AFDDomainHttpsParametersArgs =
        com.pulumi.azurenative.cdn.inputs.AFDDomainHttpsParametersArgs.builder()
            .certificateType(
                certificateType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .minimumTlsVersion(minimumTlsVersion?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .secret(secret?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AFDDomainHttpsParametersArgs].
 */
@PulumiTagMarker
public class AFDDomainHttpsParametersArgsBuilder internal constructor() {
    private var certificateType: Output<Either<String, AfdCertificateType>>? = null

    private var minimumTlsVersion: Output<AfdMinimumTlsVersion>? = null

    private var secret: Output<ResourceReferenceArgs>? = null

    /**
     * @param value Defines the source of the SSL certificate.
     */
    @JvmName("idbdvifnaqjqoipk")
    public suspend fun certificateType(`value`: Output<Either<String, AfdCertificateType>>) {
        this.certificateType = value
    }

    /**
     * @param value TLS protocol version that will be used for Https
     */
    @JvmName("mkevnxiggjfjqecf")
    public suspend fun minimumTlsVersion(`value`: Output<AfdMinimumTlsVersion>) {
        this.minimumTlsVersion = value
    }

    /**
     * @param value Resource reference to the secret. ie. subs/rg/profile/secret
     */
    @JvmName("xvluegaxvhptdoth")
    public suspend fun secret(`value`: Output<ResourceReferenceArgs>) {
        this.secret = value
    }

    /**
     * @param value Defines the source of the SSL certificate.
     */
    @JvmName("yxhqmqelipdbnbiq")
    public suspend fun certificateType(`value`: Either<String, AfdCertificateType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateType = mapped
    }

    /**
     * @param value Defines the source of the SSL certificate.
     */
    @JvmName("acdgeukcvoocirbx")
    public fun certificateType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AfdCertificateType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateType = mapped
    }

    /**
     * @param value Defines the source of the SSL certificate.
     */
    @JvmName("ghetajwibmgusswt")
    public fun certificateType(`value`: AfdCertificateType) {
        val toBeMapped = Either.ofRight<String, AfdCertificateType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateType = mapped
    }

    /**
     * @param value TLS protocol version that will be used for Https
     */
    @JvmName("rmrhnvxbfodnlwem")
    public suspend fun minimumTlsVersion(`value`: AfdMinimumTlsVersion?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value Resource reference to the secret. ie. subs/rg/profile/secret
     */
    @JvmName("sibefteidchsmjyq")
    public suspend fun secret(`value`: ResourceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secret = mapped
    }

    /**
     * @param argument Resource reference to the secret. ie. subs/rg/profile/secret
     */
    @JvmName("dasvfwrcismjublu")
    public suspend fun secret(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.secret = mapped
    }

    internal fun build(): AFDDomainHttpsParametersArgs = AFDDomainHttpsParametersArgs(
        certificateType = certificateType ?: throw PulumiNullFieldException("certificateType"),
        minimumTlsVersion = minimumTlsVersion,
        secret = secret,
    )
}
