@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.AzureFirstPartyManagedCertificateParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure FirstParty Managed Certificate provided by other first party resource providers to enable HTTPS.
 * @property subjectAlternativeNames The list of SANs.
 * @property type The type of the secret resource.
 * Expected value is 'AzureFirstPartyManagedCertificate'.
 */
public data class AzureFirstPartyManagedCertificateParametersArgs(
    public val subjectAlternativeNames: Output<List<String>>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.AzureFirstPartyManagedCertificateParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.AzureFirstPartyManagedCertificateParametersArgs =
        com.pulumi.azurenative.cdn.inputs.AzureFirstPartyManagedCertificateParametersArgs.builder()
            .subjectAlternativeNames(
                subjectAlternativeNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureFirstPartyManagedCertificateParametersArgs].
 */
@PulumiTagMarker
public class AzureFirstPartyManagedCertificateParametersArgsBuilder internal constructor() {
    private var subjectAlternativeNames: Output<List<String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The list of SANs.
     */
    @JvmName("ssueoiibcfobmchq")
    public suspend fun subjectAlternativeNames(`value`: Output<List<String>>) {
        this.subjectAlternativeNames = value
    }

    @JvmName("coogmojbtrbxnlpt")
    public suspend fun subjectAlternativeNames(vararg values: Output<String>) {
        this.subjectAlternativeNames = Output.all(values.asList())
    }

    /**
     * @param values The list of SANs.
     */
    @JvmName("nlsscmmltcfpxulp")
    public suspend fun subjectAlternativeNames(values: List<Output<String>>) {
        this.subjectAlternativeNames = Output.all(values)
    }

    /**
     * @param value The type of the secret resource.
     * Expected value is 'AzureFirstPartyManagedCertificate'.
     */
    @JvmName("pppclyvjtdxcnyhy")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The list of SANs.
     */
    @JvmName("fkqowlgijlihijtu")
    public suspend fun subjectAlternativeNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subjectAlternativeNames = mapped
    }

    /**
     * @param values The list of SANs.
     */
    @JvmName("jhxxuwpvqanaloqu")
    public suspend fun subjectAlternativeNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subjectAlternativeNames = mapped
    }

    /**
     * @param value The type of the secret resource.
     * Expected value is 'AzureFirstPartyManagedCertificate'.
     */
    @JvmName("faqxfafpvlfschnx")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureFirstPartyManagedCertificateParametersArgs =
        AzureFirstPartyManagedCertificateParametersArgs(
            subjectAlternativeNames = subjectAlternativeNames,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
