@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.CacheConfigurationArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.RuleCacheBehavior
import com.pulumi.azurenative.cdn.kotlin.enums.RuleIsCompressionEnabled
import com.pulumi.azurenative.cdn.kotlin.enums.RuleQueryStringCachingBehavior
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration object.
 * @property cacheBehavior Caching behavior for the requests
 * @property cacheDuration The duration for which the content needs to be cached. Allowed format is [d&#46;]hh:mm:ss
 * @property isCompressionEnabled Indicates whether content compression is enabled. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
 * @property queryParameters query parameters to include or exclude (comma separated).
 * @property queryStringCachingBehavior Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore specific query strings, cache every request with a unique URL, or cache specific query strings.
 */
public data class CacheConfigurationArgs(
    public val cacheBehavior: Output<Either<String, RuleCacheBehavior>>? = null,
    public val cacheDuration: Output<String>? = null,
    public val isCompressionEnabled: Output<Either<String, RuleIsCompressionEnabled>>? = null,
    public val queryParameters: Output<String>? = null,
    public val queryStringCachingBehavior: Output<Either<String, RuleQueryStringCachingBehavior>>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.CacheConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.CacheConfigurationArgs =
        com.pulumi.azurenative.cdn.inputs.CacheConfigurationArgs.builder()
            .cacheBehavior(
                cacheBehavior?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .cacheDuration(cacheDuration?.applyValue({ args0 -> args0 }))
            .isCompressionEnabled(
                isCompressionEnabled?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .queryParameters(queryParameters?.applyValue({ args0 -> args0 }))
            .queryStringCachingBehavior(
                queryStringCachingBehavior?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [CacheConfigurationArgs].
 */
@PulumiTagMarker
public class CacheConfigurationArgsBuilder internal constructor() {
    private var cacheBehavior: Output<Either<String, RuleCacheBehavior>>? = null

    private var cacheDuration: Output<String>? = null

    private var isCompressionEnabled: Output<Either<String, RuleIsCompressionEnabled>>? = null

    private var queryParameters: Output<String>? = null

    private var queryStringCachingBehavior: Output<Either<String, RuleQueryStringCachingBehavior>>? =
        null

    /**
     * @param value Caching behavior for the requests
     */
    @JvmName("elvfmoujhucaoype")
    public suspend fun cacheBehavior(`value`: Output<Either<String, RuleCacheBehavior>>) {
        this.cacheBehavior = value
    }

    /**
     * @param value The duration for which the content needs to be cached. Allowed format is [d&#46;]hh:mm:ss
     */
    @JvmName("yydqdvqrubfndxas")
    public suspend fun cacheDuration(`value`: Output<String>) {
        this.cacheDuration = value
    }

    /**
     * @param value Indicates whether content compression is enabled. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
     */
    @JvmName("lbdgnhuajmkmopmy")
    public suspend fun isCompressionEnabled(`value`: Output<Either<String, RuleIsCompressionEnabled>>) {
        this.isCompressionEnabled = value
    }

    /**
     * @param value query parameters to include or exclude (comma separated).
     */
    @JvmName("jlgwpnpmdaihfvbi")
    public suspend fun queryParameters(`value`: Output<String>) {
        this.queryParameters = value
    }

    /**
     * @param value Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore specific query strings, cache every request with a unique URL, or cache specific query strings.
     */
    @JvmName("nfixhdqhgepygqsh")
    public suspend fun queryStringCachingBehavior(`value`: Output<Either<String, RuleQueryStringCachingBehavior>>) {
        this.queryStringCachingBehavior = value
    }

    /**
     * @param value Caching behavior for the requests
     */
    @JvmName("evpaniufbvallwgg")
    public suspend fun cacheBehavior(`value`: Either<String, RuleCacheBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheBehavior = mapped
    }

    /**
     * @param value Caching behavior for the requests
     */
    @JvmName("acmyiqguugvyjwgu")
    public fun cacheBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RuleCacheBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cacheBehavior = mapped
    }

    /**
     * @param value Caching behavior for the requests
     */
    @JvmName("nmfqswolthytqsrs")
    public fun cacheBehavior(`value`: RuleCacheBehavior) {
        val toBeMapped = Either.ofRight<String, RuleCacheBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cacheBehavior = mapped
    }

    /**
     * @param value The duration for which the content needs to be cached. Allowed format is [d&#46;]hh:mm:ss
     */
    @JvmName("eghmrorkxqslfxtg")
    public suspend fun cacheDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheDuration = mapped
    }

    /**
     * @param value Indicates whether content compression is enabled. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
     */
    @JvmName("sfdrjmjanwbgmqcd")
    public suspend fun isCompressionEnabled(`value`: Either<String, RuleIsCompressionEnabled>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isCompressionEnabled = mapped
    }

    /**
     * @param value Indicates whether content compression is enabled. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
     */
    @JvmName("fqwowqcimnviwpxn")
    public fun isCompressionEnabled(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RuleIsCompressionEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isCompressionEnabled = mapped
    }

    /**
     * @param value Indicates whether content compression is enabled. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
     */
    @JvmName("npomchnvcesghyxg")
    public fun isCompressionEnabled(`value`: RuleIsCompressionEnabled) {
        val toBeMapped = Either.ofRight<String, RuleIsCompressionEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isCompressionEnabled = mapped
    }

    /**
     * @param value query parameters to include or exclude (comma separated).
     */
    @JvmName("thdfejtfnevfimrr")
    public suspend fun queryParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryParameters = mapped
    }

    /**
     * @param value Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore specific query strings, cache every request with a unique URL, or cache specific query strings.
     */
    @JvmName("atihykvyreyoqbuo")
    public suspend fun queryStringCachingBehavior(`value`: Either<String, RuleQueryStringCachingBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStringCachingBehavior = mapped
    }

    /**
     * @param value Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore specific query strings, cache every request with a unique URL, or cache specific query strings.
     */
    @JvmName("hemmxewknmuhsbkg")
    public fun queryStringCachingBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RuleQueryStringCachingBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStringCachingBehavior = mapped
    }

    /**
     * @param value Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore specific query strings, cache every request with a unique URL, or cache specific query strings.
     */
    @JvmName("jddodqawryavpesk")
    public fun queryStringCachingBehavior(`value`: RuleQueryStringCachingBehavior) {
        val toBeMapped = Either.ofRight<String, RuleQueryStringCachingBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStringCachingBehavior = mapped
    }

    internal fun build(): CacheConfigurationArgs = CacheConfigurationArgs(
        cacheBehavior = cacheBehavior,
        cacheDuration = cacheDuration,
        isCompressionEnabled = isCompressionEnabled,
        queryParameters = queryParameters,
        queryStringCachingBehavior = queryStringCachingBehavior,
    )
}
