@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeepCreatedOriginGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The origin group for CDN content which is added when creating a CDN endpoint. Traffic is sent to the origins within the origin group based on origin health.
 * @property healthProbeSettings Health probe settings to the origin that is used to determine the health of the origin.
 * @property name Origin group name which must be unique within the endpoint.
 * @property origins The source of the content being delivered via CDN within given origin group.
 * @property responseBasedOriginErrorDetectionSettings The JSON object that contains the properties to determine origin health using real requests/responses.This property is currently not supported.
 * @property trafficRestorationTimeToHealedOrNewEndpointsInMinutes Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
 */
public data class DeepCreatedOriginGroupArgs(
    public val healthProbeSettings: Output<HealthProbeParametersArgs>? = null,
    public val name: Output<String>,
    public val origins: Output<List<ResourceReferenceArgs>>,
    public val responseBasedOriginErrorDetectionSettings: Output<ResponseBasedOriginErrorDetectionParametersArgs>? = null,
    public val trafficRestorationTimeToHealedOrNewEndpointsInMinutes: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeepCreatedOriginGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeepCreatedOriginGroupArgs =
        com.pulumi.azurenative.cdn.inputs.DeepCreatedOriginGroupArgs.builder()
            .healthProbeSettings(
                healthProbeSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .origins(
                origins.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .responseBasedOriginErrorDetectionSettings(
                responseBasedOriginErrorDetectionSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .trafficRestorationTimeToHealedOrNewEndpointsInMinutes(
                trafficRestorationTimeToHealedOrNewEndpointsInMinutes?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [DeepCreatedOriginGroupArgs].
 */
@PulumiTagMarker
public class DeepCreatedOriginGroupArgsBuilder internal constructor() {
    private var healthProbeSettings: Output<HealthProbeParametersArgs>? = null

    private var name: Output<String>? = null

    private var origins: Output<List<ResourceReferenceArgs>>? = null

    private var responseBasedOriginErrorDetectionSettings:
        Output<ResponseBasedOriginErrorDetectionParametersArgs>? = null

    private var trafficRestorationTimeToHealedOrNewEndpointsInMinutes: Output<Int>? = null

    /**
     * @param value Health probe settings to the origin that is used to determine the health of the origin.
     */
    @JvmName("qslpuaynnplxrflr")
    public suspend fun healthProbeSettings(`value`: Output<HealthProbeParametersArgs>) {
        this.healthProbeSettings = value
    }

    /**
     * @param value Origin group name which must be unique within the endpoint.
     */
    @JvmName("ddsjpqyapnqnrxrd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The source of the content being delivered via CDN within given origin group.
     */
    @JvmName("ehqvxyhaxvgvvxqv")
    public suspend fun origins(`value`: Output<List<ResourceReferenceArgs>>) {
        this.origins = value
    }

    @JvmName("wgrihgsgmbaqpphx")
    public suspend fun origins(vararg values: Output<ResourceReferenceArgs>) {
        this.origins = Output.all(values.asList())
    }

    /**
     * @param values The source of the content being delivered via CDN within given origin group.
     */
    @JvmName("flxxxkufpjykcldu")
    public suspend fun origins(values: List<Output<ResourceReferenceArgs>>) {
        this.origins = Output.all(values)
    }

    /**
     * @param value The JSON object that contains the properties to determine origin health using real requests/responses.This property is currently not supported.
     */
    @JvmName("nejyeobcbkuheqjf")
    public suspend fun responseBasedOriginErrorDetectionSettings(`value`: Output<ResponseBasedOriginErrorDetectionParametersArgs>) {
        this.responseBasedOriginErrorDetectionSettings = value
    }

    /**
     * @param value Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
     */
    @JvmName("ovgrydoswakkblko")
    public suspend fun trafficRestorationTimeToHealedOrNewEndpointsInMinutes(`value`: Output<Int>) {
        this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes = value
    }

    /**
     * @param value Health probe settings to the origin that is used to determine the health of the origin.
     */
    @JvmName("mflahmefmgxknutd")
    public suspend fun healthProbeSettings(`value`: HealthProbeParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthProbeSettings = mapped
    }

    /**
     * @param argument Health probe settings to the origin that is used to determine the health of the origin.
     */
    @JvmName("wrbbhovbpwanxwdc")
    public suspend fun healthProbeSettings(argument: suspend HealthProbeParametersArgsBuilder.() -> Unit) {
        val toBeMapped = HealthProbeParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.healthProbeSettings = mapped
    }

    /**
     * @param value Origin group name which must be unique within the endpoint.
     */
    @JvmName("eirrukuaujhmfowm")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The source of the content being delivered via CDN within given origin group.
     */
    @JvmName("yooggcnwqjdvejlw")
    public suspend fun origins(`value`: List<ResourceReferenceArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.origins = mapped
    }

    /**
     * @param argument The source of the content being delivered via CDN within given origin group.
     */
    @JvmName("sfgplyjbtdnpnosx")
    public suspend fun origins(argument: List<suspend ResourceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.origins = mapped
    }

    /**
     * @param argument The source of the content being delivered via CDN within given origin group.
     */
    @JvmName("xhygahqveagpftqr")
    public suspend fun origins(vararg argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.origins = mapped
    }

    /**
     * @param argument The source of the content being delivered via CDN within given origin group.
     */
    @JvmName("sjjrfmliuxeilwul")
    public suspend fun origins(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.origins = mapped
    }

    /**
     * @param values The source of the content being delivered via CDN within given origin group.
     */
    @JvmName("vjjscxuhjxdpaypq")
    public suspend fun origins(vararg values: ResourceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.origins = mapped
    }

    /**
     * @param value The JSON object that contains the properties to determine origin health using real requests/responses.This property is currently not supported.
     */
    @JvmName("tthdaucilsedghbq")
    public suspend fun responseBasedOriginErrorDetectionSettings(`value`: ResponseBasedOriginErrorDetectionParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseBasedOriginErrorDetectionSettings = mapped
    }

    /**
     * @param argument The JSON object that contains the properties to determine origin health using real requests/responses.This property is currently not supported.
     */
    @JvmName("kwlqqvgtlmdfyxld")
    public suspend fun responseBasedOriginErrorDetectionSettings(argument: suspend ResponseBasedOriginErrorDetectionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = ResponseBasedOriginErrorDetectionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.responseBasedOriginErrorDetectionSettings = mapped
    }

    /**
     * @param value Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
     */
    @JvmName("ngmpaathumhqsvtf")
    public suspend fun trafficRestorationTimeToHealedOrNewEndpointsInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes = mapped
    }

    internal fun build(): DeepCreatedOriginGroupArgs = DeepCreatedOriginGroupArgs(
        healthProbeSettings = healthProbeSettings,
        name = name ?: throw PulumiNullFieldException("name"),
        origins = origins ?: throw PulumiNullFieldException("origins"),
        responseBasedOriginErrorDetectionSettings = responseBasedOriginErrorDetectionSettings,
        trafficRestorationTimeToHealedOrNewEndpointsInMinutes = trafficRestorationTimeToHealedOrNewEndpointsInMinutes,
    )
}
