@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleCacheExpirationActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the cache expiration action for the delivery rule.
 * @property name The name of the action for the delivery rule.
 * Expected value is 'CacheExpiration'.
 * @property parameters Defines the parameters for the action.
 */
public data class DeliveryRuleCacheExpirationActionArgs(
    public val name: Output<String>,
    public val parameters: Output<CacheExpirationActionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleCacheExpirationActionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleCacheExpirationActionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleCacheExpirationActionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleCacheExpirationActionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleCacheExpirationActionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<CacheExpirationActionParametersArgs>? = null

    /**
     * @param value The name of the action for the delivery rule.
     * Expected value is 'CacheExpiration'.
     */
    @JvmName("kvquankbwlgmewkk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the action.
     */
    @JvmName("ytxrqabmuvrighvq")
    public suspend fun parameters(`value`: Output<CacheExpirationActionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the action for the delivery rule.
     * Expected value is 'CacheExpiration'.
     */
    @JvmName("gbynulgymdopydcq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the action.
     */
    @JvmName("coapryvdprftwqgv")
    public suspend fun parameters(`value`: CacheExpirationActionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the action.
     */
    @JvmName("gabyfxcaecmjqabo")
    public suspend fun parameters(argument: suspend CacheExpirationActionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = CacheExpirationActionParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleCacheExpirationActionArgs =
        DeliveryRuleCacheExpirationActionArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            parameters = parameters ?: throw PulumiNullFieldException("parameters"),
        )
}
