@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRulePostArgsConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the PostArgs condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'PostArgs'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRulePostArgsConditionArgs(
    public val name: Output<String>,
    public val parameters: Output<PostArgsMatchConditionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRulePostArgsConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRulePostArgsConditionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRulePostArgsConditionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRulePostArgsConditionArgs].
 */
@PulumiTagMarker
public class DeliveryRulePostArgsConditionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<PostArgsMatchConditionParametersArgs>? = null

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'PostArgs'.
     */
    @JvmName("ccthgmjviwhacjwi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("fffkpvnirvbbljcc")
    public suspend fun parameters(`value`: Output<PostArgsMatchConditionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'PostArgs'.
     */
    @JvmName("ehacmlbictwfjnty")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("ypvyvcqjyreljclk")
    public suspend fun parameters(`value`: PostArgsMatchConditionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the condition.
     */
    @JvmName("qtiqifajhomulycd")
    public suspend fun parameters(argument: suspend PostArgsMatchConditionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PostArgsMatchConditionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRulePostArgsConditionArgs = DeliveryRulePostArgsConditionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
