@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestSchemeConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the RequestScheme condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'RequestScheme'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleRequestSchemeConditionArgs(
    public val name: Output<String>,
    public val parameters: Output<RequestSchemeMatchConditionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestSchemeConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestSchemeConditionArgs =
        com.pulumi.azurenative.cdn.inputs.DeliveryRuleRequestSchemeConditionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryRuleRequestSchemeConditionArgs].
 */
@PulumiTagMarker
public class DeliveryRuleRequestSchemeConditionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<RequestSchemeMatchConditionParametersArgs>? = null

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'RequestScheme'.
     */
    @JvmName("ofyvshbcybxujuav")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("dlkwacxrqulpnavm")
    public suspend fun parameters(`value`: Output<RequestSchemeMatchConditionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the condition for the delivery rule.
     * Expected value is 'RequestScheme'.
     */
    @JvmName("ijaxamdldybnvlkd")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the condition.
     */
    @JvmName("tplpmysiupfskumw")
    public suspend fun parameters(`value`: RequestSchemeMatchConditionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the condition.
     */
    @JvmName("xeqmwvqkbextvtfa")
    public suspend fun parameters(argument: suspend RequestSchemeMatchConditionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = RequestSchemeMatchConditionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): DeliveryRuleRequestSchemeConditionArgs =
        DeliveryRuleRequestSchemeConditionArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            parameters = parameters ?: throw PulumiNullFieldException("parameters"),
        )
}
