@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the Web Application Firewall policy for the endpoint (if applicable)
 * @property id Resource ID.
 */
public data class EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLinkArgs(
    public val id: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLinkArgs =
        com.pulumi.azurenative.cdn.inputs.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLinkArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLinkArgs].
 */
@PulumiTagMarker
public class EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLinkArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("dxuastndonlksrfu")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("lojfupjrpjuvqmcd")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLinkArgs =
        EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLinkArgs(
            id = id,
        )
}
