@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.GetRuleSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property ruleSetName Name of the rule set under the profile which is unique globally.
 */
public data class GetRuleSetPlainArgs(
    public val profileName: String,
    public val resourceGroupName: String,
    public val ruleSetName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.GetRuleSetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.GetRuleSetPlainArgs =
        com.pulumi.azurenative.cdn.inputs.GetRuleSetPlainArgs.builder()
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .ruleSetName(ruleSetName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRuleSetPlainArgs].
 */
@PulumiTagMarker
public class GetRuleSetPlainArgsBuilder internal constructor() {
    private var profileName: String? = null

    private var resourceGroupName: String? = null

    private var ruleSetName: String? = null

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("ijtlrlevqhuthaei")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("dnpastljgitcluwp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the rule set under the profile which is unique globally.
     */
    @JvmName("gbisqwkbiqgqyilk")
    public suspend fun ruleSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleSetName = mapped
    }

    internal fun build(): GetRuleSetPlainArgs = GetRuleSetPlainArgs(
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        ruleSetName = ruleSetName ?: throw PulumiNullFieldException("ruleSetName"),
    )
}
