@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.KeyVaultSigningKeyParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the parameters for using a user's KeyVault for URL Signing Key.
 * @property resourceGroupName Resource group of the user's Key Vault containing the secret
 * @property secretName The name of secret in Key Vault.
 * @property secretVersion The version(GUID) of secret in Key Vault.
 * @property subscriptionId Subscription Id of the user's Key Vault containing the secret
 * @property typeName
 * @property vaultName The name of the user's Key Vault containing the secret
 */
public data class KeyVaultSigningKeyParametersArgs(
    public val resourceGroupName: Output<String>,
    public val secretName: Output<String>,
    public val secretVersion: Output<String>,
    public val subscriptionId: Output<String>,
    public val typeName: Output<String>,
    public val vaultName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.KeyVaultSigningKeyParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.KeyVaultSigningKeyParametersArgs =
        com.pulumi.azurenative.cdn.inputs.KeyVaultSigningKeyParametersArgs.builder()
            .resourceGroupName(resourceGroupName.applyValue({ args0 -> args0 }))
            .secretName(secretName.applyValue({ args0 -> args0 }))
            .secretVersion(secretVersion.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId.applyValue({ args0 -> args0 }))
            .typeName(typeName.applyValue({ args0 -> args0 }))
            .vaultName(vaultName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultSigningKeyParametersArgs].
 */
@PulumiTagMarker
public class KeyVaultSigningKeyParametersArgsBuilder internal constructor() {
    private var resourceGroupName: Output<String>? = null

    private var secretName: Output<String>? = null

    private var secretVersion: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var typeName: Output<String>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value Resource group of the user's Key Vault containing the secret
     */
    @JvmName("xqsbrybimqmgxiyi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of secret in Key Vault.
     */
    @JvmName("euvrjgshkdqkoeee")
    public suspend fun secretName(`value`: Output<String>) {
        this.secretName = value
    }

    /**
     * @param value The version(GUID) of secret in Key Vault.
     */
    @JvmName("lljvdhsqvfdjuioq")
    public suspend fun secretVersion(`value`: Output<String>) {
        this.secretVersion = value
    }

    /**
     * @param value Subscription Id of the user's Key Vault containing the secret
     */
    @JvmName("sdyuhpdwysfbroah")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value
     */
    @JvmName("lbmmivwnggshlgkj")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value The name of the user's Key Vault containing the secret
     */
    @JvmName("nhesanohbiaughbb")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value Resource group of the user's Key Vault containing the secret
     */
    @JvmName("loclhoykmbpymgyo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of secret in Key Vault.
     */
    @JvmName("qvmcftosjkqyfbdn")
    public suspend fun secretName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretName = mapped
    }

    /**
     * @param value The version(GUID) of secret in Key Vault.
     */
    @JvmName("unhltvprjghqlwoh")
    public suspend fun secretVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretVersion = mapped
    }

    /**
     * @param value Subscription Id of the user's Key Vault containing the secret
     */
    @JvmName("sghpchkvntfmwxmd")
    public suspend fun subscriptionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value
     */
    @JvmName("vyugletgykwgodrv")
    public suspend fun typeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    /**
     * @param value The name of the user's Key Vault containing the secret
     */
    @JvmName("pvvpmngqxbtgkeec")
    public suspend fun vaultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): KeyVaultSigningKeyParametersArgs = KeyVaultSigningKeyParametersArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        secretName = secretName ?: throw PulumiNullFieldException("secretName"),
        secretVersion = secretVersion ?: throw PulumiNullFieldException("secretVersion"),
        subscriptionId = subscriptionId ?: throw PulumiNullFieldException("subscriptionId"),
        typeName = typeName ?: throw PulumiNullFieldException("typeName"),
        vaultName = vaultName ?: throw PulumiNullFieldException("vaultName"),
    )
}
