@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.LoadBalancingSettingsParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Round-Robin load balancing settings for a backend pool
 * @property additionalLatencyInMilliseconds The additional latency in milliseconds for probes to fall into the lowest latency bucket
 * @property sampleSize The number of samples to consider for load balancing decisions
 * @property successfulSamplesRequired The number of samples within the sample period that must succeed
 */
public data class LoadBalancingSettingsParametersArgs(
    public val additionalLatencyInMilliseconds: Output<Int>? = null,
    public val sampleSize: Output<Int>? = null,
    public val successfulSamplesRequired: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.LoadBalancingSettingsParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.LoadBalancingSettingsParametersArgs =
        com.pulumi.azurenative.cdn.inputs.LoadBalancingSettingsParametersArgs.builder()
            .additionalLatencyInMilliseconds(additionalLatencyInMilliseconds?.applyValue({ args0 -> args0 }))
            .sampleSize(sampleSize?.applyValue({ args0 -> args0 }))
            .successfulSamplesRequired(successfulSamplesRequired?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancingSettingsParametersArgs].
 */
@PulumiTagMarker
public class LoadBalancingSettingsParametersArgsBuilder internal constructor() {
    private var additionalLatencyInMilliseconds: Output<Int>? = null

    private var sampleSize: Output<Int>? = null

    private var successfulSamplesRequired: Output<Int>? = null

    /**
     * @param value The additional latency in milliseconds for probes to fall into the lowest latency bucket
     */
    @JvmName("mpobrrpalmvycthc")
    public suspend fun additionalLatencyInMilliseconds(`value`: Output<Int>) {
        this.additionalLatencyInMilliseconds = value
    }

    /**
     * @param value The number of samples to consider for load balancing decisions
     */
    @JvmName("vnmdhxxrnijdbtoe")
    public suspend fun sampleSize(`value`: Output<Int>) {
        this.sampleSize = value
    }

    /**
     * @param value The number of samples within the sample period that must succeed
     */
    @JvmName("qemstmfqedeidxdj")
    public suspend fun successfulSamplesRequired(`value`: Output<Int>) {
        this.successfulSamplesRequired = value
    }

    /**
     * @param value The additional latency in milliseconds for probes to fall into the lowest latency bucket
     */
    @JvmName("iqkspxncjghkguqm")
    public suspend fun additionalLatencyInMilliseconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalLatencyInMilliseconds = mapped
    }

    /**
     * @param value The number of samples to consider for load balancing decisions
     */
    @JvmName("qnwsxuanhyepuawu")
    public suspend fun sampleSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sampleSize = mapped
    }

    /**
     * @param value The number of samples within the sample period that must succeed
     */
    @JvmName("sjhhqbwnejsojdjg")
    public suspend fun successfulSamplesRequired(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successfulSamplesRequired = mapped
    }

    internal fun build(): LoadBalancingSettingsParametersArgs = LoadBalancingSettingsParametersArgs(
        additionalLatencyInMilliseconds = additionalLatencyInMilliseconds,
        sampleSize = sampleSize,
        successfulSamplesRequired = successfulSamplesRequired,
    )
}
