@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.SharedPrivateLinkResourcePropertiesArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.SharedPrivateLinkResourceStatus
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes the properties of an existing Shared Private Link Resource to use when connecting to a private origin.
 * @property groupId The group id from the provider of resource the shared private link resource is for.
 * @property privateLink The resource id of the resource the shared private link resource is for.
 * @property privateLinkLocation The location of the shared private link resource
 * @property requestMessage The request message for requesting approval of the shared private link resource.
 * @property status Status of the shared private link resource. Can be Pending, Approved, Rejected, Disconnected, or Timeout.
 */
public data class SharedPrivateLinkResourcePropertiesArgs(
    public val groupId: Output<String>? = null,
    public val privateLink: Output<ResourceReferenceArgs>? = null,
    public val privateLinkLocation: Output<String>? = null,
    public val requestMessage: Output<String>? = null,
    public val status: Output<SharedPrivateLinkResourceStatus>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.SharedPrivateLinkResourcePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.SharedPrivateLinkResourcePropertiesArgs =
        com.pulumi.azurenative.cdn.inputs.SharedPrivateLinkResourcePropertiesArgs.builder()
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .privateLink(privateLink?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateLinkLocation(privateLinkLocation?.applyValue({ args0 -> args0 }))
            .requestMessage(requestMessage?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SharedPrivateLinkResourcePropertiesArgs].
 */
@PulumiTagMarker
public class SharedPrivateLinkResourcePropertiesArgsBuilder internal constructor() {
    private var groupId: Output<String>? = null

    private var privateLink: Output<ResourceReferenceArgs>? = null

    private var privateLinkLocation: Output<String>? = null

    private var requestMessage: Output<String>? = null

    private var status: Output<SharedPrivateLinkResourceStatus>? = null

    /**
     * @param value The group id from the provider of resource the shared private link resource is for.
     */
    @JvmName("iklumcnneqklgbdf")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The resource id of the resource the shared private link resource is for.
     */
    @JvmName("nykrqgwgkwhoigkb")
    public suspend fun privateLink(`value`: Output<ResourceReferenceArgs>) {
        this.privateLink = value
    }

    /**
     * @param value The location of the shared private link resource
     */
    @JvmName("rdhvlhlddefrwgme")
    public suspend fun privateLinkLocation(`value`: Output<String>) {
        this.privateLinkLocation = value
    }

    /**
     * @param value The request message for requesting approval of the shared private link resource.
     */
    @JvmName("pomhuaffdcygvrnm")
    public suspend fun requestMessage(`value`: Output<String>) {
        this.requestMessage = value
    }

    /**
     * @param value Status of the shared private link resource. Can be Pending, Approved, Rejected, Disconnected, or Timeout.
     */
    @JvmName("djvshuqbencpfcmx")
    public suspend fun status(`value`: Output<SharedPrivateLinkResourceStatus>) {
        this.status = value
    }

    /**
     * @param value The group id from the provider of resource the shared private link resource is for.
     */
    @JvmName("weftnhipmpidjlow")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The resource id of the resource the shared private link resource is for.
     */
    @JvmName("vfuhpnavueoodglv")
    public suspend fun privateLink(`value`: ResourceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLink = mapped
    }

    /**
     * @param argument The resource id of the resource the shared private link resource is for.
     */
    @JvmName("afivrajiplqeipgr")
    public suspend fun privateLink(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateLink = mapped
    }

    /**
     * @param value The location of the shared private link resource
     */
    @JvmName("brlwbproocqhsneb")
    public suspend fun privateLinkLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkLocation = mapped
    }

    /**
     * @param value The request message for requesting approval of the shared private link resource.
     */
    @JvmName("ccbfxbjholxxuovl")
    public suspend fun requestMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMessage = mapped
    }

    /**
     * @param value Status of the shared private link resource. Can be Pending, Approved, Rejected, Disconnected, or Timeout.
     */
    @JvmName("khcroupqivcnmbhs")
    public suspend fun status(`value`: SharedPrivateLinkResourceStatus?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): SharedPrivateLinkResourcePropertiesArgs =
        SharedPrivateLinkResourcePropertiesArgs(
            groupId = groupId,
            privateLink = privateLink,
            privateLinkLocation = privateLinkLocation,
            requestMessage = requestMessage,
            status = status,
        )
}
