@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.UrlSigningActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the url signing action for the delivery rule.
 * @property name The name of the action for the delivery rule.
 * Expected value is 'UrlSigning'.
 * @property parameters Defines the parameters for the action.
 */
public data class UrlSigningActionArgs(
    public val name: Output<String>,
    public val parameters: Output<UrlSigningActionParametersArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.UrlSigningActionArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.UrlSigningActionArgs =
        com.pulumi.azurenative.cdn.inputs.UrlSigningActionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [UrlSigningActionArgs].
 */
@PulumiTagMarker
public class UrlSigningActionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<UrlSigningActionParametersArgs>? = null

    /**
     * @param value The name of the action for the delivery rule.
     * Expected value is 'UrlSigning'.
     */
    @JvmName("jvawtvbplpdulncb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines the parameters for the action.
     */
    @JvmName("keguvoalnwxyqhcb")
    public suspend fun parameters(`value`: Output<UrlSigningActionParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The name of the action for the delivery rule.
     * Expected value is 'UrlSigning'.
     */
    @JvmName("eablmadeppixvnjs")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the parameters for the action.
     */
    @JvmName("wxpqluheftasawqo")
    public suspend fun parameters(`value`: UrlSigningActionParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Defines the parameters for the action.
     */
    @JvmName("vnfkptckeawefysj")
    public suspend fun parameters(argument: suspend UrlSigningActionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = UrlSigningActionParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    internal fun build(): UrlSigningActionArgs = UrlSigningActionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
    )
}
