@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.inputs

import com.pulumi.azurenative.cdn.inputs.UrlSigningKeyParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Url signing key parameters
 * @property keyId Defines the customer defined key Id. This id will exist in the incoming request to indicate the key used to form the hash.
 * @property secretSource Resource reference to the Azure Key Vault secret. Expected to be in format of /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
 * @property secretVersion Version of the secret to be used
 * @property type The type of the secret resource.
 * Expected value is 'UrlSigningKey'.
 */
public data class UrlSigningKeyParametersArgs(
    public val keyId: Output<String>,
    public val secretSource: Output<ResourceReferenceArgs>,
    public val secretVersion: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.inputs.UrlSigningKeyParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.inputs.UrlSigningKeyParametersArgs =
        com.pulumi.azurenative.cdn.inputs.UrlSigningKeyParametersArgs.builder()
            .keyId(keyId.applyValue({ args0 -> args0 }))
            .secretSource(secretSource.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .secretVersion(secretVersion?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UrlSigningKeyParametersArgs].
 */
@PulumiTagMarker
public class UrlSigningKeyParametersArgsBuilder internal constructor() {
    private var keyId: Output<String>? = null

    private var secretSource: Output<ResourceReferenceArgs>? = null

    private var secretVersion: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Defines the customer defined key Id. This id will exist in the incoming request to indicate the key used to form the hash.
     */
    @JvmName("ukbwbhfvsqqhmtbr")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value Resource reference to the Azure Key Vault secret. Expected to be in format of /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
     */
    @JvmName("rxiapfcxeiksameg")
    public suspend fun secretSource(`value`: Output<ResourceReferenceArgs>) {
        this.secretSource = value
    }

    /**
     * @param value Version of the secret to be used
     */
    @JvmName("xoprmtogquxirtlh")
    public suspend fun secretVersion(`value`: Output<String>) {
        this.secretVersion = value
    }

    /**
     * @param value The type of the secret resource.
     * Expected value is 'UrlSigningKey'.
     */
    @JvmName("muwjvsjfmbqivsvx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Defines the customer defined key Id. This id will exist in the incoming request to indicate the key used to form the hash.
     */
    @JvmName("sbfkvfxdchjtqach")
    public suspend fun keyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    /**
     * @param value Resource reference to the Azure Key Vault secret. Expected to be in format of /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
     */
    @JvmName("bxixebalcokxlyyc")
    public suspend fun secretSource(`value`: ResourceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretSource = mapped
    }

    /**
     * @param argument Resource reference to the Azure Key Vault secret. Expected to be in format of /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
     */
    @JvmName("qrbanvqscrpamuuv")
    public suspend fun secretSource(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.secretSource = mapped
    }

    /**
     * @param value Version of the secret to be used
     */
    @JvmName("hdxhaokhrnmyvwsi")
    public suspend fun secretVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretVersion = mapped
    }

    /**
     * @param value The type of the secret resource.
     * Expected value is 'UrlSigningKey'.
     */
    @JvmName("smkqdslpglnbbjmr")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): UrlSigningKeyParametersArgs = UrlSigningKeyParametersArgs(
        keyId = keyId ?: throw PulumiNullFieldException("keyId"),
        secretSource = secretSource ?: throw PulumiNullFieldException("secretSource"),
        secretVersion = secretVersion,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
