@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The JSON object that contains the properties to secure a domain.
 * @property certificateType Defines the source of the SSL certificate.
 * @property minimumTlsVersion TLS protocol version that will be used for Https
 * @property secret Resource reference to the secret. ie. subs/rg/profile/secret
 */
public data class AFDDomainHttpsParametersResponse(
    public val certificateType: String,
    public val minimumTlsVersion: String? = null,
    public val secret: ResourceReferenceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.AFDDomainHttpsParametersResponse): AFDDomainHttpsParametersResponse = AFDDomainHttpsParametersResponse(
            certificateType = javaType.certificateType(),
            minimumTlsVersion = javaType.minimumTlsVersion().map({ args0 -> args0 }).orElse(null),
            secret = javaType.secret().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
