@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Reference to another resource along with its state.
 * @property id Resource ID.
 * @property isActive Whether the resource is active or inactive
 */
public data class ActivatedResourceReferenceResponse(
    public val id: String? = null,
    public val isActive: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.ActivatedResourceReferenceResponse): ActivatedResourceReferenceResponse = ActivatedResourceReferenceResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            isActive = javaType.isActive(),
        )
    }
}
