@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration object.
 * @property cacheBehavior Caching behavior for the requests
 * @property cacheDuration The duration for which the content needs to be cached. Allowed format is [d&#46;]hh:mm:ss
 * @property isCompressionEnabled Indicates whether content compression is enabled. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
 * @property queryParameters query parameters to include or exclude (comma separated).
 * @property queryStringCachingBehavior Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore specific query strings, cache every request with a unique URL, or cache specific query strings.
 */
public data class CacheConfigurationResponse(
    public val cacheBehavior: String? = null,
    public val cacheDuration: String? = null,
    public val isCompressionEnabled: String? = null,
    public val queryParameters: String? = null,
    public val queryStringCachingBehavior: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.CacheConfigurationResponse): CacheConfigurationResponse = CacheConfigurationResponse(
            cacheBehavior = javaType.cacheBehavior().map({ args0 -> args0 }).orElse(null),
            cacheDuration = javaType.cacheDuration().map({ args0 -> args0 }).orElse(null),
            isCompressionEnabled = javaType.isCompressionEnabled().map({ args0 -> args0 }).orElse(null),
            queryParameters = javaType.queryParameters().map({ args0 -> args0 }).orElse(null),
            queryStringCachingBehavior = javaType.queryStringCachingBehavior().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
