@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * settings for compression.
 * @property contentTypesToCompress List of content types on which compression applies. The value should be a valid MIME type.
 * @property isCompressionEnabled Indicates whether content compression is enabled on AzureFrontDoor. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
 */
public data class CompressionSettingsResponse(
    public val contentTypesToCompress: List<String>? = null,
    public val isCompressionEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.CompressionSettingsResponse): CompressionSettingsResponse = CompressionSettingsResponse(
            contentTypesToCompress = javaType.contentTypesToCompress().map({ args0 -> args0 }),
            isCompressionEnabled = javaType.isCompressionEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
