@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Custom domains created on the CDN endpoint.
 * @property hostName The host name of the custom domain. Must be a domain name.
 * @property name Custom domain name.
 * @property validationData Special validation or data may be required when delivering CDN to some regions due to local compliance reasons. E.g. ICP license number of a custom domain is required to deliver content in China.
 */
public data class DeepCreatedCustomDomainResponse(
    public val hostName: String,
    public val name: String,
    public val validationData: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeepCreatedCustomDomainResponse): DeepCreatedCustomDomainResponse = DeepCreatedCustomDomainResponse(
            hostName = javaType.hostName(),
            name = javaType.name(),
            validationData = javaType.validationData().map({ args0 -> args0 }).orElse(null),
        )
    }
}
