@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The origin group for CDN content which is added when creating a CDN endpoint. Traffic is sent to the origins within the origin group based on origin health.
 * @property healthProbeSettings Health probe settings to the origin that is used to determine the health of the origin.
 * @property name Origin group name which must be unique within the endpoint.
 * @property origins The source of the content being delivered via CDN within given origin group.
 * @property responseBasedOriginErrorDetectionSettings The JSON object that contains the properties to determine origin health using real requests/responses.This property is currently not supported.
 * @property trafficRestorationTimeToHealedOrNewEndpointsInMinutes Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
 */
public data class DeepCreatedOriginGroupResponse(
    public val healthProbeSettings: HealthProbeParametersResponse? = null,
    public val name: String,
    public val origins: List<ResourceReferenceResponse>,
    public val responseBasedOriginErrorDetectionSettings: ResponseBasedOriginErrorDetectionParametersResponse? = null,
    public val trafficRestorationTimeToHealedOrNewEndpointsInMinutes: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeepCreatedOriginGroupResponse): DeepCreatedOriginGroupResponse = DeepCreatedOriginGroupResponse(
            healthProbeSettings = javaType.healthProbeSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.HealthProbeParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            origins = javaType.origins().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            responseBasedOriginErrorDetectionSettings = javaType.responseBasedOriginErrorDetectionSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.ResponseBasedOriginErrorDetectionParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            trafficRestorationTimeToHealedOrNewEndpointsInMinutes = javaType.trafficRestorationTimeToHealedOrNewEndpointsInMinutes().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
