@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the cache-key query string action for the delivery rule.
 * @property name The name of the action for the delivery rule.
 * Expected value is 'CacheKeyQueryString'.
 * @property parameters Defines the parameters for the action.
 */
public data class DeliveryRuleCacheKeyQueryStringActionResponse(
    public val name: String,
    public val parameters: CacheKeyQueryStringActionParametersResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleCacheKeyQueryStringActionResponse): DeliveryRuleCacheKeyQueryStringActionResponse =
            DeliveryRuleCacheKeyQueryStringActionResponse(
                name = javaType.name(),
                parameters = javaType.parameters().let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.CacheKeyQueryStringActionParametersResponse.Companion.toKotlin(args0)
                }),
            )
    }
}
