@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the ClientPort condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'ClientPort'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleClientPortConditionResponse(
    public val name: String,
    public val parameters: ClientPortMatchConditionParametersResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleClientPortConditionResponse): DeliveryRuleClientPortConditionResponse = DeliveryRuleClientPortConditionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.ClientPortMatchConditionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
