@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the HttpVersion condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'HttpVersion'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleHttpVersionConditionResponse(
    public val name: String,
    public val parameters: HttpVersionMatchConditionParametersResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleHttpVersionConditionResponse): DeliveryRuleHttpVersionConditionResponse = DeliveryRuleHttpVersionConditionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.HttpVersionMatchConditionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
