@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the PostArgs condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'PostArgs'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRulePostArgsConditionResponse(
    public val name: String,
    public val parameters: PostArgsMatchConditionParametersResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRulePostArgsConditionResponse): DeliveryRulePostArgsConditionResponse = DeliveryRulePostArgsConditionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.PostArgsMatchConditionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
