@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the RemoteAddress condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'RemoteAddress'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleRemoteAddressConditionResponse(
    public val name: String,
    public val parameters: RemoteAddressMatchConditionParametersResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleRemoteAddressConditionResponse): DeliveryRuleRemoteAddressConditionResponse = DeliveryRuleRemoteAddressConditionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.RemoteAddressMatchConditionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
