@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the RequestHeader condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'RequestHeader'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleRequestHeaderConditionResponse(
    public val name: String,
    public val parameters: RequestHeaderMatchConditionParametersResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleRequestHeaderConditionResponse): DeliveryRuleRequestHeaderConditionResponse = DeliveryRuleRequestHeaderConditionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.RequestHeaderMatchConditionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
