@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A rule that specifies a set of actions and conditions
 * @property actions A list of actions that are executed when all the conditions of a rule are satisfied.
 * @property conditions A list of conditions that must be matched for the actions to be executed
 * @property name Name of the rule
 * @property order The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
 */
public data class DeliveryRuleResponse(
    public val actions: List<Any>,
    public val conditions: List<Any>? = null,
    public val name: String? = null,
    public val order: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleResponse): DeliveryRuleResponse = DeliveryRuleResponse(
            actions = javaType.actions().map({ args0 -> args0 }),
            conditions = javaType.conditions().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            order = javaType.order(),
        )
    }
}
