@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the SslProtocol condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'SslProtocol'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleSslProtocolConditionResponse(
    public val name: String,
    public val parameters: SslProtocolMatchConditionParametersResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleSslProtocolConditionResponse): DeliveryRuleSslProtocolConditionResponse = DeliveryRuleSslProtocolConditionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.SslProtocolMatchConditionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
