@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the UrlFileExtension condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'UrlFileExtension'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleUrlFileExtensionConditionResponse(
    public val name: String,
    public val parameters: UrlFileExtensionMatchConditionParametersResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleUrlFileExtensionConditionResponse): DeliveryRuleUrlFileExtensionConditionResponse =
            DeliveryRuleUrlFileExtensionConditionResponse(
                name = javaType.name(),
                parameters = javaType.parameters().let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.UrlFileExtensionMatchConditionParametersResponse.Companion.toKotlin(args0)
                }),
            )
    }
}
