@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Rules defining user's geo access within a CDN endpoint.
 * @property action Action of the geo filter, i.e. allow or block access.
 * @property countryCodes Two letter country or region codes defining user country or region access in a geo filter, e.g. AU, MX, US.
 * @property relativePath Relative path applicable to geo filter. (e.g. '/mypictures', '/mypicture/kitty.jpg', and etc.)
 */
public data class GeoFilterResponse(
    public val action: String,
    public val countryCodes: List<String>,
    public val relativePath: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.GeoFilterResponse): GeoFilterResponse = GeoFilterResponse(
            action = javaType.action(),
            countryCodes = javaType.countryCodes().map({ args0 -> args0 }),
            relativePath = javaType.relativePath(),
        )
    }
}
