@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g. www.contoso.com.
 * @property azureDnsZone Resource reference to the Azure DNS zone
 * @property deploymentStatus
 * @property domainValidationState Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step. DCV stands for DomainControlValidation.
 * @property extendedProperties Key-Value pair representing migration properties for domains.
 * @property hostName The host name of the domain. Must be a domain name.
 * @property id Resource ID.
 * @property name Resource name.
 * @property preValidatedCustomDomainResourceId Resource reference to the Azure resource where custom domain ownership was prevalidated
 * @property profileName The name of the profile which holds the domain.
 * @property provisioningState Provisioning status
 * @property systemData Read only system data
 * @property tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default.
 * @property type Resource type.
 * @property validationProperties Values the customer needs to validate domain ownership
 */
public data class GetAFDCustomDomainResult(
    public val azureDnsZone: ResourceReferenceResponse? = null,
    public val deploymentStatus: String,
    public val domainValidationState: String,
    public val extendedProperties: Map<String, String>? = null,
    public val hostName: String,
    public val id: String,
    public val name: String,
    public val preValidatedCustomDomainResourceId: ResourceReferenceResponse? = null,
    public val profileName: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tlsSettings: AFDDomainHttpsParametersResponse? = null,
    public val type: String,
    public val validationProperties: DomainValidationPropertiesResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.GetAFDCustomDomainResult): GetAFDCustomDomainResult = GetAFDCustomDomainResult(
            azureDnsZone = javaType.azureDnsZone().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deploymentStatus = javaType.deploymentStatus(),
            domainValidationState = javaType.domainValidationState(),
            extendedProperties = javaType.extendedProperties().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            hostName = javaType.hostName(),
            id = javaType.id(),
            name = javaType.name(),
            preValidatedCustomDomainResourceId = javaType.preValidatedCustomDomainResourceId().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            profileName = javaType.profileName(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tlsSettings = javaType.tlsSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.AFDDomainHttpsParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            validationProperties = javaType.validationProperties().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.DomainValidationPropertiesResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
