@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Azure Front Door endpoint is the entity within a Azure Front Door profile containing configuration information such as origin, protocol, content caching and delivery behavior. The AzureFrontDoor endpoint uses the URL format <endpointname>.azureedge.net.
 * @property autoGeneratedDomainNameLabelScope Indicates the endpoint name reuse scope. The default value is TenantReuse.
 * @property deploymentStatus
 * @property enabledState Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
 * @property hostName The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g. contoso.azureedge.net
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property profileName The name of the profile which holds the endpoint.
 * @property provisioningState Provisioning status
 * @property systemData Read only system data
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetAFDEndpointResult(
    public val autoGeneratedDomainNameLabelScope: String? = null,
    public val deploymentStatus: String,
    public val enabledState: String? = null,
    public val hostName: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val profileName: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.GetAFDEndpointResult): GetAFDEndpointResult = GetAFDEndpointResult(
            autoGeneratedDomainNameLabelScope = javaType.autoGeneratedDomainNameLabelScope().map({ args0 ->
                args0
            }).orElse(null),
            deploymentStatus = javaType.deploymentStatus(),
            enabledState = javaType.enabledState().map({ args0 -> args0 }).orElse(null),
            hostName = javaType.hostName(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            profileName = javaType.profileName(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
