@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * CDN origin is the source of the content being delivered via CDN. When the edge nodes represented by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured origins.
 * @property enabled Origin is enabled for load balancing or not
 * @property hostName The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint.
 * @property httpPort The value of the HTTP port. Must be between 1 and 65535.
 * @property httpsPort The value of the HTTPS port. Must be between 1 and 65535.
 * @property id Resource ID.
 * @property name Resource name.
 * @property originHostHeader The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint
 * @property priority Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5
 * @property privateEndpointStatus The approval status for the connection to the Private Link
 * @property privateLinkAlias The Alias of the Private Link resource. Populating this optional field indicates that this origin is 'Private'
 * @property privateLinkApprovalMessage A custom message to be included in the approval request to connect to the Private Link.
 * @property privateLinkLocation The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
 * @property privateLinkResourceId The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
 * @property provisioningState Provisioning status of the origin.
 * @property resourceState Resource status of the origin.
 * @property systemData Read only system data
 * @property type Resource type.
 * @property weight Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
 */
public data class GetOriginResult(
    public val enabled: Boolean? = null,
    public val hostName: String,
    public val httpPort: Int? = null,
    public val httpsPort: Int? = null,
    public val id: String,
    public val name: String,
    public val originHostHeader: String? = null,
    public val priority: Int? = null,
    public val privateEndpointStatus: String,
    public val privateLinkAlias: String? = null,
    public val privateLinkApprovalMessage: String? = null,
    public val privateLinkLocation: String? = null,
    public val privateLinkResourceId: String? = null,
    public val provisioningState: String,
    public val resourceState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val weight: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.GetOriginResult): GetOriginResult = GetOriginResult(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            hostName = javaType.hostName(),
            httpPort = javaType.httpPort().map({ args0 -> args0 }).orElse(null),
            httpsPort = javaType.httpsPort().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            originHostHeader = javaType.originHostHeader().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            privateEndpointStatus = javaType.privateEndpointStatus(),
            privateLinkAlias = javaType.privateLinkAlias().map({ args0 -> args0 }).orElse(null),
            privateLinkApprovalMessage = javaType.privateLinkApprovalMessage().map({ args0 ->
                args0
            }).orElse(null),
            privateLinkLocation = javaType.privateLinkLocation().map({ args0 -> args0 }).orElse(null),
            privateLinkResourceId = javaType.privateLinkResourceId().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resourceState = javaType.resourceState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
