@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Defines web application firewall policy for Azure CDN.
 * @property customRules Describes custom rules inside the policy.
 * @property endpointLinks Describes Azure CDN endpoints associated with this Web Application Firewall policy.
 * @property etag Gets a unique read-only string that changes whenever the resource is updated.
 * @property extendedProperties Key-Value pair representing additional properties for Web Application Firewall policy.
 * @property id Resource ID.
 * @property location Resource location.
 * @property managedRules Describes managed rules inside the policy.
 * @property name Resource name.
 * @property policySettings Describes  policySettings for policy
 * @property provisioningState Provisioning state of the WebApplicationFirewallPolicy.
 * @property rateLimitRules Describes rate limit rules inside the policy.
 * @property resourceState
 * @property sku The pricing tier (defines a CDN provider, feature list and rate) of the CdnWebApplicationFirewallPolicy.
 * @property systemData Read only system data
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetPolicyResult(
    public val customRules: CustomRuleListResponse? = null,
    public val endpointLinks: List<CdnEndpointResponse>,
    public val etag: String? = null,
    public val extendedProperties: Map<String, String>? = null,
    public val id: String,
    public val location: String,
    public val managedRules: ManagedRuleSetListResponse? = null,
    public val name: String,
    public val policySettings: PolicySettingsResponse? = null,
    public val provisioningState: String,
    public val rateLimitRules: RateLimitRuleListResponse? = null,
    public val resourceState: String,
    public val sku: SkuResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.GetPolicyResult): GetPolicyResult = GetPolicyResult(
            customRules = javaType.customRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.CustomRuleListResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            endpointLinks = javaType.endpointLinks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.CdnEndpointResponse.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            extendedProperties = javaType.extendedProperties().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            id = javaType.id(),
            location = javaType.location(),
            managedRules = javaType.managedRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.ManagedRuleSetListResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            policySettings = javaType.policySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.PolicySettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            rateLimitRules = javaType.rateLimitRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.RateLimitRuleListResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resourceState = javaType.resourceState(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
