@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A profile is a logical grouping of endpoints that share the same settings.
 * @property extendedProperties Key-Value pair representing additional properties for profiles.
 * @property frontDoorId The Id of the frontdoor.
 * @property id Resource ID.
 * @property identity Managed service identity (system assigned and/or user assigned identities).
 * @property kind Kind of the profile. Used by portal to differentiate traditional CDN profile and new AFD profile.
 * @property location Resource location.
 * @property name Resource name.
 * @property originResponseTimeoutSeconds Send and receive timeout on forwarding request to the origin. When timeout is reached, the request fails and returns.
 * @property provisioningState Provisioning status of the profile.
 * @property resourceState Resource status of the profile.
 * @property sku The pricing tier (defines Azure Front Door Standard or Premium or a CDN provider, feature list and rate) of the profile.
 * @property systemData Read only system data
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetProfileResult(
    public val extendedProperties: Map<String, String>,
    public val frontDoorId: String,
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val kind: String,
    public val location: String,
    public val name: String,
    public val originResponseTimeoutSeconds: Int? = null,
    public val provisioningState: String,
    public val resourceState: String,
    public val sku: SkuResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.GetProfileResult): GetProfileResult = GetProfileResult(
            extendedProperties = javaType.extendedProperties().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            frontDoorId = javaType.frontDoorId(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kind = javaType.kind(),
            location = javaType.location(),
            name = javaType.name(),
            originResponseTimeoutSeconds = javaType.originResponseTimeoutSeconds().map({ args0 ->
                args0
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resourceState = javaType.resourceState(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
