@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Friendly Routes name mapping to the any Routes or secret related information.
 * @property cacheConfiguration The caching configuration for this route. To disable caching, do not provide a cacheConfiguration object.
 * @property customDomains Domains referenced by this endpoint.
 * @property deploymentStatus
 * @property enabledState Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
 * @property endpointName The name of the endpoint which holds the route.
 * @property forwardingProtocol Protocol this rule will use when forwarding traffic to backends.
 * @property httpsRedirect Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way to set up this rule and it will be the first rule that gets executed.
 * @property id Resource ID.
 * @property linkToDefaultDomain whether this route will be linked to the default endpoint domain.
 * @property name Resource name.
 * @property originGroup A reference to the origin group.
 * @property originPath A directory path on the origin that AzureFrontDoor can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
 * @property patternsToMatch The route patterns of the rule.
 * @property provisioningState Provisioning status
 * @property ruleSets rule sets referenced by this endpoint.
 * @property supportedProtocols List of supported protocols for this route.
 * @property systemData Read only system data
 * @property type Resource type.
 */
public data class GetRouteResult(
    public val cacheConfiguration: AfdRouteCacheConfigurationResponse? = null,
    public val customDomains: List<ActivatedResourceReferenceResponse>? = null,
    public val deploymentStatus: String,
    public val enabledState: String? = null,
    public val endpointName: String,
    public val forwardingProtocol: String? = null,
    public val httpsRedirect: String? = null,
    public val id: String,
    public val linkToDefaultDomain: String? = null,
    public val name: String,
    public val originGroup: ResourceReferenceResponse,
    public val originPath: String? = null,
    public val patternsToMatch: List<String>? = null,
    public val provisioningState: String,
    public val ruleSets: List<ResourceReferenceResponse>? = null,
    public val supportedProtocols: List<String>? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.GetRouteResult): GetRouteResult = GetRouteResult(
            cacheConfiguration = javaType.cacheConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.AfdRouteCacheConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customDomains = javaType.customDomains().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.ActivatedResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            deploymentStatus = javaType.deploymentStatus(),
            enabledState = javaType.enabledState().map({ args0 -> args0 }).orElse(null),
            endpointName = javaType.endpointName(),
            forwardingProtocol = javaType.forwardingProtocol().map({ args0 -> args0 }).orElse(null),
            httpsRedirect = javaType.httpsRedirect().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            linkToDefaultDomain = javaType.linkToDefaultDomain().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            originGroup = javaType.originGroup().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
            }),
            originPath = javaType.originPath().map({ args0 -> args0 }).orElse(null),
            patternsToMatch = javaType.patternsToMatch().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            ruleSets = javaType.ruleSets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            supportedProtocols = javaType.supportedProtocols().map({ args0 -> args0 }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
