@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Friendly RuleSet name mapping to the any RuleSet or secret related information.
 * @property deploymentStatus
 * @property id Resource ID.
 * @property name Resource name.
 * @property profileName The name of the profile which holds the rule set.
 * @property provisioningState Provisioning status
 * @property systemData Read only system data
 * @property type Resource type.
 */
public data class GetRuleSetResult(
    public val deploymentStatus: String,
    public val id: String,
    public val name: String,
    public val profileName: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.GetRuleSetResult): GetRuleSetResult = GetRuleSetResult(
            deploymentStatus = javaType.deploymentStatus(),
            id = javaType.id(),
            name = javaType.name(),
            profileName = javaType.profileName(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
