@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * SecurityPolicy association for AzureFrontDoor profile
 * @property deploymentStatus
 * @property id Resource ID.
 * @property name Resource name.
 * @property parameters object which contains security policy parameters
 * @property profileName The name of the profile which holds the security policy.
 * @property provisioningState Provisioning status
 * @property systemData Read only system data
 * @property type Resource type.
 */
public data class GetSecurityPolicyResult(
    public val deploymentStatus: String,
    public val id: String,
    public val name: String,
    public val parameters: SecurityPolicyWebApplicationFirewallParametersResponse? = null,
    public val profileName: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.GetSecurityPolicyResult): GetSecurityPolicyResult = GetSecurityPolicyResult(
            deploymentStatus = javaType.deploymentStatus(),
            id = javaType.id(),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.SecurityPolicyWebApplicationFirewallParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            profileName = javaType.profileName(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
