@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the parameters for the request header action.
 * @property headerAction Action to perform
 * @property headerName Name of the header to modify
 * @property typeName
 * @property value Value for the specified action
 */
public data class HeaderActionParametersResponse(
    public val headerAction: String,
    public val headerName: String,
    public val typeName: String,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.HeaderActionParametersResponse): HeaderActionParametersResponse = HeaderActionParametersResponse(
            headerAction = javaType.headerAction(),
            headerName = javaType.headerName(),
            typeName = javaType.typeName(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
