@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * The JSON object that represents the range for http status codes
 * @property begin The inclusive start of the http status code range.
 * @property end The inclusive end of the http status code range.
 */
public data class HttpErrorRangeParametersResponse(
    public val begin: Int? = null,
    public val end: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.HttpErrorRangeParametersResponse): HttpErrorRangeParametersResponse = HttpErrorRangeParametersResponse(
            begin = javaType.begin().map({ args0 -> args0 }).orElse(null),
            end = javaType.end().map({ args0 -> args0 }).orElse(null),
        )
    }
}
