@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the parameters for using a user's KeyVault certificate for securing custom domain.
 * @property deleteRule Describes the action that shall be taken when the certificate is removed from Key Vault.
 * @property resourceGroupName Resource group of the user's Key Vault containing the SSL certificate
 * @property secretName The name of Key Vault Secret (representing the full certificate PFX) in Key Vault.
 * @property secretVersion The version(GUID) of Key Vault Secret in Key Vault.
 * @property subscriptionId Subscription Id of the user's Key Vault containing the SSL certificate
 * @property typeName
 * @property updateRule Describes the action that shall be taken when the certificate is updated in Key Vault.
 * @property vaultName The name of the user's Key Vault containing the SSL certificate
 */
public data class KeyVaultCertificateSourceParametersResponse(
    public val deleteRule: String,
    public val resourceGroupName: String,
    public val secretName: String,
    public val secretVersion: String? = null,
    public val subscriptionId: String,
    public val typeName: String,
    public val updateRule: String,
    public val vaultName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.KeyVaultCertificateSourceParametersResponse): KeyVaultCertificateSourceParametersResponse = KeyVaultCertificateSourceParametersResponse(
            deleteRule = javaType.deleteRule(),
            resourceGroupName = javaType.resourceGroupName(),
            secretName = javaType.secretName(),
            secretVersion = javaType.secretVersion().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId(),
            typeName = javaType.typeName(),
            updateRule = javaType.updateRule(),
            vaultName = javaType.vaultName(),
        )
    }
}
