@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the parameters for using a user's KeyVault for URL Signing Key.
 * @property resourceGroupName Resource group of the user's Key Vault containing the secret
 * @property secretName The name of secret in Key Vault.
 * @property secretVersion The version(GUID) of secret in Key Vault.
 * @property subscriptionId Subscription Id of the user's Key Vault containing the secret
 * @property typeName
 * @property vaultName The name of the user's Key Vault containing the secret
 */
public data class KeyVaultSigningKeyParametersResponse(
    public val resourceGroupName: String,
    public val secretName: String,
    public val secretVersion: String,
    public val subscriptionId: String,
    public val typeName: String,
    public val vaultName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.KeyVaultSigningKeyParametersResponse): KeyVaultSigningKeyParametersResponse = KeyVaultSigningKeyParametersResponse(
            resourceGroupName = javaType.resourceGroupName(),
            secretName = javaType.secretName(),
            secretVersion = javaType.secretVersion(),
            subscriptionId = javaType.subscriptionId(),
            typeName = javaType.typeName(),
            vaultName = javaType.vaultName(),
        )
    }
}
