@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Round-Robin load balancing settings for a backend pool
 * @property additionalLatencyInMilliseconds The additional latency in milliseconds for probes to fall into the lowest latency bucket
 * @property sampleSize The number of samples to consider for load balancing decisions
 * @property successfulSamplesRequired The number of samples within the sample period that must succeed
 */
public data class LoadBalancingSettingsParametersResponse(
    public val additionalLatencyInMilliseconds: Int? = null,
    public val sampleSize: Int? = null,
    public val successfulSamplesRequired: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.LoadBalancingSettingsParametersResponse): LoadBalancingSettingsParametersResponse = LoadBalancingSettingsParametersResponse(
            additionalLatencyInMilliseconds = javaType.additionalLatencyInMilliseconds().map({ args0 ->
                args0
            }).orElse(null),
            sampleSize = javaType.sampleSize().map({ args0 -> args0 }).orElse(null),
            successfulSamplesRequired = javaType.successfulSamplesRequired().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
