@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Define match conditions
 * @property matchValue List of possible match values.
 * @property matchVariable Match variable to compare against.
 * @property negateCondition Describes if the result of this condition should be negated.
 * @property operator Describes operator to be matched
 * @property selector Selector can used to match a specific key for QueryString, Cookies, RequestHeader or PostArgs.
 * @property transforms List of transforms.
 */
public data class MatchConditionResponse(
    public val matchValue: List<String>,
    public val matchVariable: String,
    public val negateCondition: Boolean? = null,
    public val `operator`: String,
    public val selector: String? = null,
    public val transforms: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.MatchConditionResponse): MatchConditionResponse = MatchConditionResponse(
            matchValue = javaType.matchValue().map({ args0 -> args0 }),
            matchVariable = javaType.matchVariable(),
            negateCondition = javaType.negateCondition().map({ args0 -> args0 }).orElse(null),
            `operator` = javaType.`operator`(),
            selector = javaType.selector().map({ args0 -> args0 }).orElse(null),
            transforms = javaType.transforms().map({ args0 -> args0 }),
        )
    }
}
