@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the parameters for the origin group override action.
 * @property originGroup defines the OriginGroup that would override the DefaultOriginGroup.
 * @property typeName
 */
public data class OriginGroupOverrideActionParametersResponse(
    public val originGroup: ResourceReferenceResponse,
    public val typeName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.OriginGroupOverrideActionParametersResponse): OriginGroupOverrideActionParametersResponse = OriginGroupOverrideActionParametersResponse(
            originGroup = javaType.originGroup().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
            }),
            typeName = javaType.typeName(),
        )
    }
}
