@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines a rate limiting rule that can be included in a waf policy
 * @property action Describes what action to be applied when rule matches
 * @property enabledState Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
 * @property matchConditions List of match conditions.
 * @property name Defines the name of the custom rule
 * @property priority Defines in what order this rule be evaluated in the overall list of custom rules
 * @property rateLimitDurationInMinutes Defines rate limit duration. Default is 1 minute.
 * @property rateLimitThreshold Defines rate limit threshold.
 */
public data class RateLimitRuleResponse(
    public val action: String,
    public val enabledState: String? = null,
    public val matchConditions: List<MatchConditionResponse>,
    public val name: String,
    public val priority: Int,
    public val rateLimitDurationInMinutes: Int,
    public val rateLimitThreshold: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.RateLimitRuleResponse): RateLimitRuleResponse = RateLimitRuleResponse(
            action = javaType.action(),
            enabledState = javaType.enabledState().map({ args0 -> args0 }).orElse(null),
            matchConditions = javaType.matchConditions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.MatchConditionResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            priority = javaType.priority(),
            rateLimitDurationInMinutes = javaType.rateLimitDurationInMinutes(),
            rateLimitThreshold = javaType.rateLimitThreshold(),
        )
    }
}
