@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines the parameters for RequestScheme match conditions
 * @property matchValues The match value for the condition of the delivery rule
 * @property negateCondition Describes if this is negate condition or not
 * @property operator Describes operator to be matched
 * @property transforms List of transforms
 * @property typeName
 */
public data class RequestSchemeMatchConditionParametersResponse(
    public val matchValues: List<String>? = null,
    public val negateCondition: Boolean? = null,
    public val `operator`: String,
    public val transforms: List<String>? = null,
    public val typeName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.RequestSchemeMatchConditionParametersResponse): RequestSchemeMatchConditionParametersResponse =
            RequestSchemeMatchConditionParametersResponse(
                matchValues = javaType.matchValues().map({ args0 -> args0 }),
                negateCondition = javaType.negateCondition().map({ args0 -> args0 }).orElse(null),
                `operator` = javaType.`operator`(),
                transforms = javaType.transforms().map({ args0 -> args0 }),
                typeName = javaType.typeName(),
            )
    }
}
